<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class UsecaseList extends ListResource {
    /**
     * Construct the UsecaseList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/Services/Usecases';
    }

    /**
     * Fetch the UsecaseInstance
     *
     * @return UsecaseInstance Fetched UsecaseInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): UsecaseInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new UsecaseInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Messaging.V1.UsecaseList]';
    }
}